/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.dialog.comp.ExtendedTreeSelectionModel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.InputNamesManager;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BlockSelectionPanel
extends DataInputPanel
implements ExtendedTreeSelectionModel.ExtendedTreeSelectionListener {
    private JScrollPane ivjJScrollPane1 = null;
    private JLabel ivjAvailableBlocksLbl = null;
    private JLabel ivjBlockNameLbl = null;
    private JTextField ivjBlockNameTf = null;
    private JTree ivjBlockTree = null;
    private static final int SORT_BLOCKS_BY_NAME_ASC = 0;
    private static final int SORT_BLOCKS_BY_NAME_DESC = 1;
    private static final int SORT_BLOCKS_BY_NUMBER_ASC = 2;
    private static final int SORT_BLOCKS_BY_NUMBER_DESC = 3;
    private int fSortBlockOrder = 0;
    private JButton ivjNameSortBtn = null;
    private JButton ivjNumberSortBtn = null;
    private WiringDiagram fWiringDiagram;
    private boolean fFlat;
    protected List fBlocks;
    protected Hashtable blocksNodesTable;
    protected Hashtable fBlockGroupNodeDict;
    protected CommentManager fCommentManager;
    protected Vector fBlockSelectionListeners;
    public static final Color HIGHLIGHTED_COLOR = Color.blue;
    protected Vector fHighlightedBlocks;
    private InputNamesManager fInputNamesManager;

    public BlockSelectionPanel() {
        this.initialize();
    }

    public BlockSelectionPanel(List blocks) {
        this.initialize();
        this.fBlocks = blocks;
    }

    public BlockSelectionPanel(List blocks, WiringDiagram wiringDiagram) {
        this.initialize();
        this.fBlocks = blocks;
        this.fWiringDiagram = wiringDiagram;
    }

    public BlockSelectionPanel(List blocks, LogoDrawing logoDrawing) {
        this(blocks);
        this.fCommentManager = logoDrawing.getCommentManager();
        this.fInputNamesManager = logoDrawing.getInputNamesManager();
        this.fWiringDiagram = logoDrawing.getWiringDiagram();
    }

    private String makeHtmlTooltip(String tooltip) {
        return "<html>" + Util.replaceString(tooltip, "\n", "<br>") + "</html>";
    }

    public BlockSelectionPanel(List blocks, CommentManager commentManager) {
        this(blocks);
        this.fCommentManager = commentManager;
    }

    public BlockSelectionPanel(List blocks, CommentManager commentManager, InputNamesManager inputNamesManager) {
        this(blocks);
        this.fCommentManager = commentManager;
        this.fInputNamesManager = inputNamesManager;
    }

    public void addBlockSelectionListener(BlockSelectionListener l) {
        if (!this.getBlockSelectionListeners().contains(l)) {
            this.fBlockSelectionListeners.addElement(l);
        }
    }

    public void addHighlightedBlock(Block block) {
        if (!this.getHighlightedBlocks().contains(block)) {
            this.getHighlightedBlocks().add(block);
        }
        this.getBlockTree().repaint();
    }

    private void blockNameTextField_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.findAgain(true);
        } else if (keyEvent.getKeyCode() == 38) {
            this.findAgain(false);
        }
    }

    public boolean checkFieldContents() {
        if (this.getSelectedBlock() == null) {
            JOptionPane.showMessageDialog(this, Language.getString("dialog.blockSelectionPanel.info.selectABlock", "Please select a block."), Language.getString("dialog.blockSelectionPanel.title", "Select block"), 1);
            return false;
        }
        return true;
    }

    public void documentEvent(DocumentEvent de) {
        this.reorderBlocks();
        if (((DefaultMutableTreeNode)this.getBlockTree().getModel().getRoot()).getChildCount() > 0) {
            this.selectTreeNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getBlockTree().getModel().getRoot()).getFirstChild());
        }
    }

    private void selectTreeNode(DefaultMutableTreeNode node) {
        if (node != null) {
            TreePath blockPath = new TreePath(node.getPath());
            this.getBlockTree().setSelectionPath(blockPath);
            this.getBlockTree().expandPath(blockPath);
            this.getBlockTree().scrollPathToVisible(blockPath);
        } else {
            this.getBlockTree().setSelectionPath(null);
        }
    }

    private void findAgain(boolean isDown) {
        DefaultMutableTreeNode selectedNode = null;
        TreePath selectionPath = this.getBlockTree().getSelectionPath();
        selectedNode = selectionPath != null ? (DefaultMutableTreeNode)this.getBlockTree().getSelectionPath().getLastPathComponent() : (DefaultMutableTreeNode)this.getBlockTree().getModel().getRoot();
        Enumeration<TreeNode> nodeEnum = ((DefaultMutableTreeNode)this.getBlockTree().getModel().getRoot()).depthFirstEnumeration();
        Vector<DefaultMutableTreeNode> blockNodeVector = new Vector<DefaultMutableTreeNode>();
        while (nodeEnum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeEnum.nextElement();
            if (!(node.getUserObject() instanceof Block)) continue;
            blockNodeVector.add(node);
        }
        int offset = 0;
        if (selectedNode != null) {
            offset = blockNodeVector.indexOf(selectedNode);
        }
        int index = isDown ? (offset + 1) % blockNodeVector.size() : ((offset == 0 ? blockNodeVector.size() : offset) - 1) % blockNodeVector.size();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)blockNodeVector.elementAt(index);
        this.selectTreeNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionGainedEvent(Block selectedBlock) {
        if (!this.getBlockSelectionListeners().isEmpty()) {
            Vector l;
            BlockSelectionPanel blockSelectionPanel = this;
            synchronized (blockSelectionPanel) {
                l = (Vector)this.getBlockSelectionListeners().clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                BlockSelectionListener bsl = (BlockSelectionListener)l.elementAt(i);
                bsl.selectionGained(selectedBlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionLostEvent(Block selectedBlock) throws PropertyVetoException {
        if (!this.getBlockSelectionListeners().isEmpty()) {
            Vector l;
            BlockSelectionPanel blockSelectionPanel = this;
            synchronized (blockSelectionPanel) {
                l = (Vector)this.getBlockSelectionListeners().clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                BlockSelectionListener bsl = (BlockSelectionListener)l.elementAt(i);
                bsl.selectionLost(selectedBlock);
            }
        }
    }

    private JLabel getAvailableBlocksLbl() {
        if (this.ivjAvailableBlocksLbl == null) {
            this.ivjAvailableBlocksLbl = new JLabel();
            this.ivjAvailableBlocksLbl.setName("AvailableBlocksLbl");
            this.ivjAvailableBlocksLbl.setText("Verf\u00fcgbare Bl\u00f6cke");
        }
        return this.ivjAvailableBlocksLbl;
    }

    private JLabel getBlockNameLbl() {
        if (this.ivjBlockNameLbl == null) {
            this.ivjBlockNameLbl = new JLabel();
            this.ivjBlockNameLbl.setName("BlockNameLbl");
            this.ivjBlockNameLbl.setText("Blockname");
        }
        return this.ivjBlockNameLbl;
    }

    private JTextField getBlockNameTf() {
        if (this.ivjBlockNameTf == null) {
            this.ivjBlockNameTf = new JTextField();
            this.ivjBlockNameTf.setName("BlockNameTf");
        }
        return this.ivjBlockNameTf;
    }

    private JButton getNameSortBtn() {
        if (this.ivjNameSortBtn == null) {
            this.ivjNameSortBtn = new RolloverButton(Global.getIcon("SortNameASC.png"));
            this.ivjNameSortBtn.setName("NameSortBtn");
        }
        this.ivjNameSortBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BlockSelectionPanel.this.fSortBlockOrder == 0) {
                    BlockSelectionPanel.this.fSortBlockOrder = 1;
                } else {
                    BlockSelectionPanel.this.fSortBlockOrder = 0;
                }
                BlockSelectionPanel.this.reorderBlocks();
            }
        });
        this.ivjNameSortBtn.setToolTipText(Language.getString("dialog.gotoBlock.sortBlocksByName", "Sort blocks by name"));
        return this.ivjNameSortBtn;
    }

    private JButton getNumberSortBtn() {
        if (this.ivjNumberSortBtn == null) {
            this.ivjNumberSortBtn = new RolloverButton(Global.getIcon("SortNumberASC.png"));
            this.ivjNumberSortBtn.setName("NumberSortBtn");
        }
        this.ivjNumberSortBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BlockSelectionPanel.this.fSortBlockOrder == 2) {
                    BlockSelectionPanel.this.fSortBlockOrder = 3;
                } else {
                    BlockSelectionPanel.this.fSortBlockOrder = 2;
                }
                BlockSelectionPanel.this.reorderBlocks();
            }
        });
        this.ivjNumberSortBtn.setToolTipText(Language.getString("dialog.gotoBlock.sortBlocksByNumber", "Sort blocks by number"));
        return this.ivjNumberSortBtn;
    }

    public Vector getBlockSelectionListeners() {
        if (this.fBlockSelectionListeners == null) {
            this.fBlockSelectionListeners = new Vector(3);
        }
        return this.fBlockSelectionListeners;
    }

    public void setSelectedBlock(Block block) {
        if (block != null) {
            this.selectTreeNode((DefaultMutableTreeNode)this.blocksNodesTable.get(block));
        } else {
            this.selectTreeNode(null);
        }
    }

    private JTree getBlockTree() {
        if (this.ivjBlockTree == null) {
            class JTreeExtended
            extends JTree {
                boolean firstClick = true;
                boolean firstRelease = true;

                JTreeExtended() {
                }

                void dispatchEventImpl(AWTEvent e) {
                    super.dispatchEvent(e);
                }

                protected void processMouseEvent(MouseEvent e) {
                    if (e.getID() == 502 && this.firstClick) {
                        this.firstRelease = false;
                        e.consume();
                        return;
                    }
                    super.processMouseEvent(e);
                }
            }
            this.ivjBlockTree = new JTreeExtended();
            this.ivjBlockTree.setName("BlockTree");
            this.ivjBlockTree.setBounds(0, 0, 78, 72);
            ExtendedTreeSelectionModel selectionModel = new ExtendedTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            this.ivjBlockTree.setSelectionModel(selectionModel);
            this.ivjBlockTree.setRowHeight(0);
            selectionModel.addTreeSelectionListener(this);
            this.getBlockNameTf().getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent de) {
                    BlockSelectionPanel.this.documentEvent(de);
                }

                public void removeUpdate(DocumentEvent de) {
                    BlockSelectionPanel.this.documentEvent(de);
                }

                public void insertUpdate(DocumentEvent de) {
                    BlockSelectionPanel.this.documentEvent(de);
                }
            });
            this.ivjBlockTree.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent me) {
                    JDialog dialog;
                    if (BlockSelectionPanel.this.ivjBlockTree.getSelectionPath() != null && !((TreeNode)BlockSelectionPanel.this.getBlockTree().getSelectionPath().getLastPathComponent()).isLeaf()) {
                        return;
                    }
                    if (me.getClickCount() == 2 && (dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, BlockSelectionPanel.this.ivjBlockTree)) != null) {
                        dialog.getRootPane().getDefaultButton().doClick();
                    }
                }
            });
            this.ivjBlockTree.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, BlockSelectionPanel.this.ivjBlockTree);
                    if (dialog != null) {
                        dialog.getRootPane().getDefaultButton().doClick();
                    }
                }
            }, KeyStroke.getKeyStroke(10, 0), 0);
            this.getBlockNameTf().addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    BlockSelectionPanel.this.blockNameTextField_keyPressed(keyEvent);
                }
            });
            ToolTipManager.sharedInstance().registerComponent(this.ivjBlockTree);
        }
        return this.ivjBlockTree;
    }

    public Vector getHighlightedBlocks() {
        if (this.fHighlightedBlocks == null) {
            this.fHighlightedBlocks = new Vector();
        }
        return this.fHighlightedBlocks;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            this.ivjJScrollPane1 = new JScrollPane();
            this.ivjJScrollPane1.setName("JScrollPane1");
            this.getJScrollPane1().setViewportView(this.getBlockTree());
        }
        return this.ivjJScrollPane1;
    }

    public Block getSelectedBlock() {
        DefaultMutableTreeNode selectedNode;
        Block block = null;
        TreePath selectionPath = this.getBlockTree().getSelectionPath();
        if (selectionPath != null && (selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()) != null && selectedNode.getUserObject() instanceof Block) {
            block = (Block)selectedNode.getUserObject();
        }
        return block;
    }

    public String getTitle() {
        return Language.getString("dialog.blockSelectionPanel.title", "Select block");
    }

    private void initialize() {
        this.setFlat(true);
        this.setName("BlockSelectionDialog");
        this.setLayout(new GridBagLayout());
        this.setSize(453, 323);
        GridBagConstraints constraintsBlockNameTf = new GridBagConstraints();
        constraintsBlockNameTf.gridx = 0;
        constraintsBlockNameTf.gridy = 1;
        constraintsBlockNameTf.fill = 2;
        constraintsBlockNameTf.weightx = 1.0;
        constraintsBlockNameTf.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getBlockNameTf(), constraintsBlockNameTf);
        GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
        constraintsJScrollPane1.gridx = 0;
        constraintsJScrollPane1.gridy = 3;
        constraintsJScrollPane1.fill = 1;
        constraintsJScrollPane1.weightx = 1.0;
        constraintsJScrollPane1.weighty = 1.0;
        constraintsJScrollPane1.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
        GridBagConstraints constraintsBlockNameLbl = new GridBagConstraints();
        constraintsBlockNameLbl.gridx = 0;
        constraintsBlockNameLbl.gridy = 0;
        constraintsBlockNameLbl.anchor = 17;
        constraintsBlockNameLbl.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.getBlockNameLbl(), constraintsBlockNameLbl);
        GridBagConstraints constraintsAvailableBlocksLbl = new GridBagConstraints();
        constraintsAvailableBlocksLbl.gridx = 0;
        constraintsAvailableBlocksLbl.gridy = 2;
        constraintsAvailableBlocksLbl.anchor = 17;
        constraintsAvailableBlocksLbl.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.getAvailableBlocksLbl(), constraintsAvailableBlocksLbl);
        JToolBar toolbarPanel = new JToolBar();
        toolbarPanel.setFloatable(false);
        toolbarPanel.add(this.getNameSortBtn());
        toolbarPanel.add(this.getNumberSortBtn());
        GridBagConstraints constraintsSortBtn = new GridBagConstraints();
        constraintsSortBtn.gridx = 0;
        constraintsSortBtn.gridy = 2;
        constraintsSortBtn.anchor = 13;
        constraintsSortBtn.insets = new Insets(4, 4, 4, 4);
        this.add((Component)toolbarPanel, constraintsSortBtn);
        this.getBlockTree().setCellRenderer(new BlockTreeCellRenderer());
    }

    public boolean isBlockHighlighted(Block block) {
        return this.getHighlightedBlocks().contains(block);
    }

    protected TreeModel createTreeModel() {
        ProgrammingLanguage language = null;
        WiringDiagram wd = this.getWiringDiagram();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        if (!this.fFlat && wd != null) {
            language = wd.getProgrammingLanguage();
            BlockGroup rootBlockGroup = language.getAvailableBlockGroups(wd.getHardware());
            rootNode = this.createNodeForGroup(rootBlockGroup);
            this.fBlockGroupNodeDict.put(rootBlockGroup, rootNode);
        } else {
            this.getBlockTree().setRootVisible(false);
        }
        Object[] aObjects = this.fBlocks.toArray();
        Block[] aBlocks = new Block[aObjects.length];
        for (int i = 0; i < aBlocks.length; ++i) {
            aBlocks[i] = (Block)aObjects[i];
        }
        Block.sortForBlockNumber(aBlocks);
        for (int x = 0; x < aBlocks.length; ++x) {
            DefaultMutableTreeNode blockNode = new DefaultMutableTreeNode(aBlocks[x]);
            this.blocksNodesTable.put(aBlocks[x], blockNode);
            blockNode.setAllowsChildren(false);
            rootNode.add(blockNode);
        }
        return new DefaultTreeModel(rootNode);
    }

    private void reorderBlocks() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getBlockTree().getModel().getRoot();
        rootNode.removeAllChildren();
        Object[] aObjects = this.fBlocks.toArray();
        Block[] aBlocks = new Block[aObjects.length];
        for (int i = 0; i < aBlocks.length; ++i) {
            aBlocks[i] = (Block)aObjects[i];
        }
        switch (this.fSortBlockOrder) {
            case 0: {
                Block.sortForBlockNumber(aBlocks);
                this.ivjNameSortBtn.setIcon(Global.getIcon("SortNameASC.png"));
                this.ivjNumberSortBtn.setIcon(Global.getIcon("SortNumberASC.png"));
                break;
            }
            case 1: {
                Block.sortForBlockNumberPrefixDesc(aBlocks);
                this.ivjNameSortBtn.setIcon(Global.getIcon("SortNameDesc.png"));
                this.ivjNumberSortBtn.setIcon(Global.getIcon("SortNumberASC.png"));
                break;
            }
            case 2: {
                Block.sortForOnlyBlockNumber(aBlocks, true);
                this.ivjNumberSortBtn.setIcon(Global.getIcon("SortNumberASC.png"));
                this.ivjNameSortBtn.setIcon(Global.getIcon("SortNameASC.png"));
                break;
            }
            case 3: {
                Block.sortForOnlyBlockNumber(aBlocks, false);
                this.ivjNumberSortBtn.setIcon(Global.getIcon("SortNumberDesc.png"));
                this.ivjNameSortBtn.setIcon(Global.getIcon("SortNameASC.png"));
            }
        }
        this.recreateBlockTree(aBlocks);
    }

    private void recreateBlockTree(Block[] aBlocks) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getBlockTree().getModel().getRoot();
        rootNode.removeAllChildren();
        String text = this.getBlockNameTf().getText().toLowerCase();
        String regex = ".*";
        if (!text.equals("")) {
            regex = text.replaceAll("\\*", ".*").replaceAll("\\?", ".?") + ".*";
        }
        for (int x = 0; x < aBlocks.length; ++x) {
            if (!aBlocks[x].getLocalizedName(true).toLowerCase().matches(regex)) continue;
            DefaultMutableTreeNode blockNode = new DefaultMutableTreeNode(aBlocks[x]);
            this.blocksNodesTable.put(aBlocks[x], blockNode);
            blockNode.setAllowsChildren(false);
            rootNode.add(blockNode);
        }
        this.getBlockTree().updateUI();
    }

    private void deleteEmptyTreeNodes(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent;
        if (node.getAllowsChildren() && node.isLeaf() && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
            parent.remove(node);
            this.deleteEmptyTreeNodes(parent);
        }
    }

    private DefaultMutableTreeNode createNodeForGroup(BlockGroup blockGroup) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(blockGroup);
        this.fBlockGroupNodeDict.put(blockGroup, node);
        for (int i = 0; i < blockGroup.getElementCount(); ++i) {
            if (!(blockGroup.getElementAt(i) instanceof BlockGroup)) continue;
            node.add(this.createNodeForGroup((BlockGroup)blockGroup.getElementAt(i)));
        }
        return node;
    }

    public void loadFieldContents() {
        this.blocksNodesTable = new Hashtable(50);
        this.fBlockGroupNodeDict = new Hashtable(15);
        this.getBlockTree().setModel(this.createTreeModel());
    }

    public void removeBlockSelectionListener(BlockSelectionListener l) {
        this.getBlockSelectionListeners().removeElement(l);
    }

    public void removeHighlightedBlock(Block block) {
        this.getHighlightedBlocks().remove(block);
        this.getBlockTree().repaint();
    }

    public void selectionWillChange(TreeSelectionEvent tse) throws PropertyVetoException {
        if (tse.getOldLeadSelectionPath() == null) {
            return;
        }
        DefaultMutableTreeNode oldSelectedNode = (DefaultMutableTreeNode)tse.getOldLeadSelectionPath().getLastPathComponent();
        if (oldSelectedNode.getUserObject() instanceof Block) {
            this.fireSelectionLostEvent((Block)oldSelectedNode.getUserObject());
        }
    }

    public void setBlocks(List blocks) {
        this.fBlocks = blocks;
        this.getBlockNameTf().setText("");
    }

    public void setFocus() {
        this.getBlockNameTf().requestFocus();
    }

    public void setLabels() {
        this.getBlockNameLbl().setText(Language.getString("dialog.gotoBlock.blockName", "Block Name(? = character, * = string):"));
        this.getAvailableBlocksLbl().setText(Language.getString("dialog.gotoBlock.availableBlocks", "dialog.gotoBlock.availableBlocks"));
    }

    public void valueChanged(TreeSelectionEvent tse) {
        DefaultMutableTreeNode newSelectedNode;
        Block selectedBlock = null;
        if (tse.getNewLeadSelectionPath() != null && (newSelectedNode = (DefaultMutableTreeNode)tse.getNewLeadSelectionPath().getLastPathComponent()).getUserObject() instanceof Block) {
            selectedBlock = (Block)newSelectedNode.getUserObject();
        }
        this.fireSelectionGainedEvent(selectedBlock);
    }

    public WiringDiagram getWiringDiagram() {
        return this.fWiringDiagram;
    }

    public void setWiringDiagram(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
    }

    public boolean isFlat() {
        return this.fFlat;
    }

    public void setFlat(boolean flat) {
        this.fFlat = flat;
    }

    public void setDefaultSortOrder() {
        this.fSortBlockOrder = 0;
    }

    public void setDefaultSortBtnText() {
        this.ivjNameSortBtn.setIcon(Global.getIcon("SortNameASC.png"));
        this.ivjNumberSortBtn.setIcon(Global.getIcon("SortNumberASC.png"));
    }

    public static interface BlockSelectionListener {
        public void selectionLost(Block var1) throws PropertyVetoException;

        public void selectionGained(Block var1);
    }

    protected class BlockTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected BlockTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof BlockGroup) {
                BlockGroup renderedBlockGroup = (BlockGroup)node.getUserObject();
                this.setText(renderedBlockGroup.getLocalizedName());
            }
            if (node.getUserObject() instanceof Block) {
                String ioName;
                Block renderedBlock = (Block)node.getUserObject();
                String blockDescription = renderedBlock.getLocalizedName(true);
                if (BlockSelectionPanel.this.fInputNamesManager != null && !(ioName = BlockSelectionPanel.this.fInputNamesManager.getInputName(renderedBlock.getNumberString())).equals("")) {
                    StringBuffer buff = new StringBuffer(40);
                    buff.append(blockDescription).append(" - ").append(ioName);
                    blockDescription = buff.toString();
                }
                this.setText(blockDescription);
                if (BlockSelectionPanel.this.isBlockHighlighted(renderedBlock)) {
                    this.setForeground(HIGHLIGHTED_COLOR);
                }
                ImageIcon icon = Global.getIcon(renderedBlock.getIconName());
                this.setIcon(icon);
                if (BlockSelectionPanel.this.fCommentManager != null) {
                    CommentParameter commentParameter = BlockSelectionPanel.this.fCommentManager.getCommentParameter(renderedBlock);
                    if (!commentParameter.equals("")) {
                        this.setToolTipText(commentParameter.getText());
                    } else {
                        this.setToolTipText(this.getText());
                    }
                }
            }
            return this;
        }

        public void setInputNamesManager(InputNamesManager manager) {
            BlockSelectionPanel.this.fInputNamesManager = manager;
        }

        public Point getToolTipLocation(MouseEvent event) {
            return this.getLocation();
        }

        public String getToolTipText() {
            return super.getToolTipText();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getMinimumSize().width, this.getMinimumSize().height + 2);
        }
    }
}

